<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNewslettersTable extends Migration {

	public function up()
	{
		Schema::create('newsletters', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->text('editor_code');
			$table->text('html');
			$table->datetime('send_date')->nullable();
			$table->boolean('send_now');
			$table->enum('state', array('not_sent', 'in_progress', 'sent'));
			$table->text('statistics')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('newsletters');
	}
}