<?php

namespace App\Models\Newletter;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Site extends Eloquent {

	protected $table = 'sites';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function client()
	{
		return $this->belongsTo('App\Models\Newletter\Client');
	}

	public function newletters()
	{
		return $this->hasMany('App\Models\Newletter\Newsletter');
	}

	public function templates()
	{
		return $this->hasMany('App\Models\Newletter\Template');
	}

	public function emails()
	{
		return $this->hasMany('App\Models\Newletter\Email');
	}

	public function automatisms()
	{
		return $this->hasMany('App\Models\Newletter\Automatism');
	}

	public function metagroups()
	{
		return $this->hasMany('App\Models\Newletter\Metagroup');
	}

}