<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->foreign('users_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('posts_tag', function(Blueprint $table) {
			$table->foreign('tag_id')->references('id')->on('tags')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('posts_tag', function(Blueprint $table) {
			$table->foreign('posts_id')->references('id')->on('posts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('works', function(Blueprint $table) {
			$table->foreign('users_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('works_cat', function(Blueprint $table) {
			$table->foreign('works_id')->references('id')->on('works')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('works_cat', function(Blueprint $table) {
			$table->foreign('cat_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('img_cat', function(Blueprint $table) {
			$table->foreign('img_id')->references('id')->on('images')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('img_cat', function(Blueprint $table) {
			$table->foreign('cat_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('woks_gal', function(Blueprint $table) {
			$table->foreign('works_id')->references('id')->on('works')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('woks_gal', function(Blueprint $table) {
			$table->foreign('img_id')->references('id')->on('images')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('posts_gal', function(Blueprint $table) {
			$table->foreign('posts_id')->references('id')->on('posts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('posts_gal', function(Blueprint $table) {
			$table->foreign('img_id')->references('id')->on('images')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_role_id_foreign');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->dropForeign('posts_users_id_foreign');
		});
		Schema::table('posts_tag', function(Blueprint $table) {
			$table->dropForeign('posts_tag_tag_id_foreign');
		});
		Schema::table('posts_tag', function(Blueprint $table) {
			$table->dropForeign('posts_tag_posts_id_foreign');
		});
		Schema::table('works', function(Blueprint $table) {
			$table->dropForeign('works_users_id_foreign');
		});
		Schema::table('works_cat', function(Blueprint $table) {
			$table->dropForeign('works_cat_works_id_foreign');
		});
		Schema::table('works_cat', function(Blueprint $table) {
			$table->dropForeign('works_cat_cat_id_foreign');
		});
		Schema::table('img_cat', function(Blueprint $table) {
			$table->dropForeign('img_cat_img_id_foreign');
		});
		Schema::table('img_cat', function(Blueprint $table) {
			$table->dropForeign('img_cat_cat_id_foreign');
		});
		Schema::table('woks_gal', function(Blueprint $table) {
			$table->dropForeign('woks_gal_works_id_foreign');
		});
		Schema::table('woks_gal', function(Blueprint $table) {
			$table->dropForeign('woks_gal_img_id_foreign');
		});
		Schema::table('posts_gal', function(Blueprint $table) {
			$table->dropForeign('posts_gal_posts_id_foreign');
		});
		Schema::table('posts_gal', function(Blueprint $table) {
			$table->dropForeign('posts_gal_img_id_foreign');
		});
	}
}