<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWorksTable extends Migration {

	public function up()
	{
		Schema::create('works', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('users_id')->unsigned();
			$table->string('title', 60)->unique();
			$table->string('slug', 30)->unique();
			$table->boolean('seen')->default(false);
			$table->boolean('active')->default(false);
			$table->string('summary');
			$table->text('content');
			$table->string('image')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('works');
	}
}