<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateArticulosTable extends Migration {

	public function up()
	{
		Schema::create('articulos', function(Blueprint $table) {
			$table->string('id', 6);
			$table->string('denominacion', 255)->nullable();
			$table->string('referencia', 255)->nullable();
			$table->string('ean', 50)->nullable();
			$table->decimal('iva', 10,2)->nullable();
			$table->string('grupo', 4)->nullable();
			$table->string('familia', 4)->nullable();
			$table->string('proveedor', 5)->nullable();
			$table->decimal('precio_de_venta', 10,2)->nullable();
			$table->integer('stock')->default('0');
			$table->string('representante', 255)->nullable();
			$table->text('descripcion')->nullable();
			$table->integer('bloqueado')->nullable();
			$table->string('marca', 4)->nullable();
			$table->integer('visible')->nullable();
			$table->decimal('precio_coste', 10,2)->nullable();
			$table->integer('tamanos_id')->unsigned()->nullable();
			$table->integer('common_fields_id')->unsigned()->nullable();
			$table->datetime('last_update')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('articulos');
	}
}