<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('restaurant_id');
			$table->integer('payment_method_id');
			$table->timestamps();
			$table->string('note');
			$table->text('address');
			$table->decimal('cost');
			$table->decimal('delivery_cost');
			$table->decimal('total');
			$table->enum('state', array('pending', 'accepted', 'rejected'));
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}