<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('eateries', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('eateries', function(Blueprint $table) {
			$table->foreign('contact_info_id')->references('id')->on('contact_infos')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('eateries', function(Blueprint $table) {
			$table->foreign('rating_id')->references('id')->on('ratings')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('eateries', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('eateries', function(Blueprint $table) {
			$table->foreign('schedule_id')->references('id')->on('schedules')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('foods', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('category_foods')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('category_foods', function(Blueprint $table) {
			$table->foreign('eatery_id')->references('id')->on('eateries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('eateries', function(Blueprint $table) {
			$table->dropForeign('eateries_category_id_foreign');
		});
		Schema::table('eateries', function(Blueprint $table) {
			$table->dropForeign('eateries_contact_info_id_foreign');
		});
		Schema::table('eateries', function(Blueprint $table) {
			$table->dropForeign('eateries_rating_id_foreign');
		});
		Schema::table('eateries', function(Blueprint $table) {
			$table->dropForeign('eateries_user_id_foreign');
		});
		Schema::table('eateries', function(Blueprint $table) {
			$table->dropForeign('eateries_schedule_id_foreign');
		});
		Schema::table('foods', function(Blueprint $table) {
			$table->dropForeign('foods_category_id_foreign');
		});
		Schema::table('category_foods', function(Blueprint $table) {
			$table->dropForeign('category_foods_eatery_id_foreign');
		});
	}
}