<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('categories', function(Blueprint $table) {
			$table->increments('id');
			$table->string('language_key', 299);
			$table->string('module', 50);
			$table->text('category_en')->nullable();
			$table->text('category_ind')->nullable();
			$table->text('category_malay')->nullable();
			$table->text('category_thai')->nullable();
			$table->text('category_urdu')->nullable();
			$table->text('category_burmese')->nullable();
			$table->text('category_rohingya')->nullable();
			$table->text('category_dari')->nullable();
			$table->text('category_somali')->nullable();
			$table->text('category_arabic')->nullable();
			$table->tinyInteger('status')->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('categories');
	}
}