<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->smallInteger('status')->unsigned()->index()->default('0');
			$table->string('number', 16);
			$table->integer('customer_id')->unsigned()->index();
			$table->integer('shop_id')->unsigned()->index();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}