<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShopOffersTable extends Migration {

	public function up()
	{
		Schema::create('shop_offers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->timestampsTz('ends_at');
			$table->smallInteger('status')->unsigned()->index()->default('0');
			$table->integer('shop_id')->unsigned();
			$table->integer('item_id')->unsigned();
			$table->smallInteger('qty')->unsigned();
			$table->decimal('price');
		});
	}

	public function down()
	{
		Schema::drop('shop_offers');
	}
}