<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Supplier extends Model 
{

    protected $table = 'suppliers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function users()
    {
        return $this->hasMany('User');
    }

    public function sites()
    {
        return $this->hasMany('Site');
    }

    public function appointments()
    {
        return $this->hasOne('Appointment');
    }

    public function patientReminders()
    {
        return $this->hasMany('PatientReminder');
    }

    public function medicalFileSharingRequests()
    {
        return $this->hasMany('MedicalFileSharingrequest');
    }

}