<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCollaborationRequestsTable extends Migration {

	public function up()
	{
		Schema::create('collaboration_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('type', array('doctor', 'lab'));
			$table->string('name');
			$table->string('city');
			$table->string('email');
			$table->string('phone');
			$table->string('specialisation')->nullable();
			$table->text('message');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('collaboration_requests');
	}
}