<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMedicalFileSharesTable extends Migration {

	public function up()
	{
		Schema::create('medical_file_shares', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('medical_file_id')->index();
			$table->bigInteger('recipient_id')->unsigned()->index();
			$table->string('recipient_type');
			$table->integer('shared_for_days')->unsigned();
			$table->bigInteger('sender_id')->unsigned()->index();
			$table->string('sender_type');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('medical_file_shares');
	}
}