<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMedicalFilesTable extends Migration {

	public function up()
	{
		Schema::create('medical_files', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('patient_id')->unsigned();
			$table->bigInteger('parent_id')->unsigned();
			$table->enum('type', array('file', 'folder'));
			$table->string('name');
			$table->bigInteger('size')->unsigned()->nullable();
			$table->string('mime_type')->nullable();
			$table->bigInteger('creator_id')->index();
			$table->timestamps();
			$table->string('path')->nullable();
			$table->string('creator_type');
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('medical_files');
	}
}