<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePatientRemindersTable extends Migration {

	public function up()
	{
		Schema::create('patient_reminders', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('patient_id')->unsigned()->index();
			$table->bigInteger('supplier_id')->unsigned()->index();
			$table->integer('appointment_id')->unsigned()->index();
			$table->text('message');
			$table->boolean('completed')->default(false);
			$table->date('date')->nullable();
			$table->integer('every_days')->unsigned()->nullable();
			$table->date('last_notified_at')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('patient_reminders');
	}
}