<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSitesTable extends Migration {

	public function up()
	{
		Schema::create('sites', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('supplier_id')->unsigned()->index();
			$table->string('city')->nullable();
			$table->string('zip')->nullable();
			$table->string('street_name')->nullable();
			$table->string('street_number')->nullable();
			$table->text('description')->nullable();
			$table->boolean('is_primary')->default(false);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('sites');
	}
}