<?php

namespace App/Models/MarketingMain;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class MarketingMain extends Eloquent {

	protected $table = 'marketing_mains';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function category()
	{
		return $this->belongsTo('MarketingCategory', 'marketing_category_id');
	}

	public function type()
	{
		return $this->belongsTo('MarketingType', 'marketing_type_id');
	}

}