<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSchedulesTable extends Migration {

	public function up()
	{
		Schema::create('schedules', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title');
			$table->integer('offset');
			$table->text('scope')->nullable();
			$table->integer('repeat_for')->default('1');
			$table->integer('target_id')->unsigned()->index();
			$table->string('enable_form_ids');
			$table->string('target_type')->index();
		});
	}

	public function down()
	{
		Schema::drop('schedules');
	}
}