<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSectionsTable extends Migration {

	public function up()
	{
		Schema::create('sections', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title')->nullable();
			$table->integer('page_id')->unsigned();
			$table->smallInteger('order')->default('1');
			$table->boolean('repeatable')->default(false);
			$table->integer('depends_on')->nullable();
			$table->json('depends_definition')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('sections');
	}
}