<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('first_name', 191);
			$table->string('second_name', 191);
			$table->string('email', 191);
			$table->string('password', 191);
			$table->date('birth_date');
			$table->enum('role', array(''client'', ''admin'', ''owner''));
			$table->string('image', 191);
			$table->enum('gender', array(''male'', ''femail''));
			$table->integer('region_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}