<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLocationsTable extends Migration {

	public function up()
	{
		Schema::create('locations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('field_code')->nullable();
			$table->string('major_field_code')->nullable();
			$table->string('sub_major_field_code')->nullable();
			$table->string('unit_field_code')->nullable();
			$table->string('specific_field_code')->nullable();
			$table->string('sin_location_name')->nullable();
			$table->string('eng_location_name')->nullable();
			$table->string('tam_location_name')->nullable();
			$table->string('sin_location_address')->nullable();
			$table->string('eng_location_address')->nullable();
			$table->string('tam_location_address')->nullable();
			$table->integer('scale')->nullable();
			$table->string('province')->nullable();
			$table->string('district')->nullable();
			$table->string('ds')->nullable();
			$table->string('gn')->nullable();
			$table->string('village')->nullable();
			$table->string('telephone')->nullable();
			$table->string('fax')->nullable();
			$table->string('email')->nullable();
			$table->integer('location_type')->nullable();
			$table->string('location_image')->nullable();
			$table->text('sin_description')->nullable();
			$table->text('eng_description')->nullable();
			$table->text('tam_description')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('locations');
	}
}