<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('answers', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('questions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->foreign('scale')->references('id')->on('scale')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('answer_list', function(Blueprint $table) {
			$table->foreign('answer_type_id')->references('id')->on('answer_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('answers', function(Blueprint $table) {
			$table->dropForeign('answers_question_id_foreign');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->dropForeign('jobs_scale_foreign');
		});
		Schema::table('answer_list', function(Blueprint $table) {
			$table->dropForeign('answer_list_answer_type_id_foreign');
		});
	}
}