<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserTable extends Migration {

	public function up()
	{
		Schema::create('user', function(Blueprint $table) {
			$table->integer('userID')->primary()->index();
			$table->string('userFirstName', 50);
			$table->string('userLastName', 50)->index();
			$table->string('userEmail', 255);
			$table->string('userPassword', 255);
			$table->integer('userBirthday');
			$table->tinyInteger('userAccessLevel');
		});
	}

	public function down()
	{
		Schema::drop('user');
	}
}