<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Translation extends Eloquent {

	protected $table = 'translations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function book()
	{
		return $this->belongsTo('Book');
	}

}