<?php

namespace App/Models;

class Restaurant extends Eloquent {

	protected $table = 'restaurants';
	public $timestamps = true;
	protected $fillable = array('name', 'area_id', 'email', 'password', 'delivery_time', 'delivery_method', 'minimum', 'delivery_fee', 'phone', 'whatsapp', 'img', 'status', 'api_token');

	public function comments()
	{
		return $this->hasMany('Comment');
	}

	public function categories()
	{
		return $this->belongsToMany('Category');
	}

	public function offers()
	{
		return $this->hasMany('Offer');
	}

	public function orders()
	{
		return $this->hasMany('Order');
	}

}