<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePackagesTable extends Migration {

	public function up()
	{
		Schema::create('packages', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('name_en', 255)->nullable();
			$table->string('description');
			$table->string('description_en', 255)->nullable();
			$table->integer('amount');
			$table->string('profit_amount');
			$table->string('referral_amount');
			$table->string('status');
			$table->integer('admin_add');
			$table->integer('admin_update');
			$table->string('admin_delete');
			$table->enum('delete_status', array('0', '1'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('packages');
	}
}