<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAboutUsTable extends Migration {

	public function up()
	{
		Schema::create('about_us', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->enum('delete_status', array('0', '1'));
			$table->string('title_ar');
			$table->string('title_en');
			$table->string('description_ar');
			$table->string('description_en');
			$table->string('mission');
			$table->string('mission_ar');
			$table->string('vision_ar');
			$table->string('meta_description_ar');
			$table->string('vision_en');
			$table->string('meta_description_en');
			$table->string('meta_kewords_ar');
			$table->string('meta_kewords_en');
			$table->string('page_title_ar');
			$table->string('page_title_en');
			$table->enum('status', array('0', '1'));
			$table->integer('admin_add');
			$table->integer('admin_update');
			$table->integer('admin_delete');
		});
	}

	public function down()
	{
		Schema::drop('about_us');
	}
}