<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWorkFlowTable extends Migration {

	public function up()
	{
		Schema::create('work_flow', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('bundle_id');
			$table->date('assign_date');
			$table->date('completed_at');
			$table->date('audited_at');
			$table->date('uploaded_at');
			$table->date('pending_at');
			$table->string('pending_reason', 255);
			$table->softDeletes();
			$table->string('userable_type', 100)->nullable();
			$table->integer('userable_id');
			$table->string('status', 100)->nullable();
			$table->text('file')->nullable();
			$table->text('notes')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('work_flow');
	}
}