<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('children', function(Blueprint $table) {
			$table->foreign('child_id')->references('id')->on('children')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('it_employees', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('writers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('character_designers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('designers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transaction_payments', function(Blueprint $table) {
			$table->foreign('transaction_id')->references('id')->on('transactions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('children', function(Blueprint $table) {
			$table->dropForeign('children_child_id_foreign');
		});
		Schema::table('it_employees', function(Blueprint $table) {
			$table->dropForeign('it_employees_user_id_foreign');
		});
		Schema::table('writers', function(Blueprint $table) {
			$table->dropForeign('writers_user_id_foreign');
		});
		Schema::table('character_designers', function(Blueprint $table) {
			$table->dropForeign('character_designers_user_id_foreign');
		});
		Schema::table('designers', function(Blueprint $table) {
			$table->dropForeign('designers_user_id_foreign');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->dropForeign('transactions_order_id_foreign');
		});
		Schema::table('transaction_payments', function(Blueprint $table) {
			$table->dropForeign('transaction_payments_transaction_id_foreign');
		});
	}
}