<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Users', function(Blueprint $table) {
			$table->foreign('profile_id')->references('id')->on('user_profile')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Users', function(Blueprint $table) {
			$table->foreign('department_id')->references('id')->on('Departments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->foreign('trainer_id')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('department_courses', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('department_courses', function(Blueprint $table) {
			$table->foreign('department_id')->references('id')->on('Departments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('co_training_requests', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('CoTraining_needs_request', function(Blueprint $table) {
			$table->foreign('department_id')->references('id')->on('Departments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sub_category_courses', function(Blueprint $table) {
			$table->foreign('category_courses')->references('id')->on('category_courses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Users', function(Blueprint $table) {
			$table->dropForeign('Users_profile_id_foreign');
		});
		Schema::table('Users', function(Blueprint $table) {
			$table->dropForeign('Users_role_id_foreign');
		});
		Schema::table('Users', function(Blueprint $table) {
			$table->dropForeign('Users_department_id_foreign');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->dropForeign('courses_trainer_id_foreign');
		});
		Schema::table('department_courses', function(Blueprint $table) {
			$table->dropForeign('department_courses_course_id_foreign');
		});
		Schema::table('department_courses', function(Blueprint $table) {
			$table->dropForeign('department_courses_department_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_user_id_foreign');
		});
		Schema::table('co_training_requests', function(Blueprint $table) {
			$table->dropForeign('co_training_requests_user_id_foreign');
		});
		Schema::table('CoTraining_needs_request', function(Blueprint $table) {
			$table->dropForeign('CoTraining_needs_request_department_id_foreign');
		});
		Schema::table('sub_category_courses', function(Blueprint $table) {
			$table->dropForeign('sub_category_courses_category_courses_foreign');
		});
	}
}