<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDoctorsTable extends Migration {

	public function up()
	{
		Schema::create('doctors', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('username', 200);
			$table->string('email', 150);
			$table->string('password', 200);
			$table->string('phone', 50)->nullable();
			$table->string('alter_phone', 50);
			$table->string('code', 20)->unique();
			$table->string('governorate', 50)->nullable();
			$table->enum('active', array('0', '1'));
			$table->string('remember_token', 120)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('doctors');
	}
}