<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHospitalsTable extends Migration {

	public function up()
	{
		Schema::create('hospitals', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 100);
			$table->string('address', 150)->nullable();
			$table->string('phone', 50);
			$table->string('second_phone', 50)->nullable();
			$table->string('working_days')->nullable();
			$table->string('work_start', 5);
			$table->string('work_end', 5)->nullable();
			$table->integer('doctorid')->unsigned();
			$table->enum('type', array('0', '1'));
		});
	}

	public function down()
	{
		Schema::drop('hospitals');
	}
}