<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShopWorkingHoursTable extends Migration {

	public function up()
	{
		Schema::create('shop_working_hours', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('shop_id')->unsigned();
			$table->tinyInteger('week_day')->unsigned()->index();
			$table->time('time_from');
			$table->time('time_to');
			$table->integer('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('shop_working_hours');
	}
}