<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdsclientsTable extends Migration {

	public function up()
	{
		Schema::create('adsclients', function(Blueprint $table) {
			$table->increments('id');
			$table->string('developerToken')->nullable();
			$table->string('client_customer_id')->nullable();
			$table->string('user_agent')->nullable();
			$table->string('client_id')->nullable();
			$table->string('client_secret')->nullable();
			$table->string('refresh_token')->nullable();
			$table->string('authorization_uri')->nullable();
			$table->string('redirect_uri')->nullable();
			$table->string('token_credential_uri')->nullable();
			$table->string('scope')->nullable();
			$table->integer('clinic_id')->unsigned()->nullable();
			$table->integer('user_id')->unsigned()->nullable();
			$table->integer('website_id')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('adsclients');
	}
}