<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'username', 'email', 'rememberToken', 'confirmation_code', 'quickbase_id', 'quickbase_company');
	protected $visible = array('name', 'username', 'email', 'rememberToken', 'confirmation_code', 'quickbase_id', 'quickbase_company');

	public function website()
	{
		return $this->hasOne('Website', 'user_id', 'id');
	}

	public function profile()
	{
		return $this->hasOne('Profile', 'id', 'profile_id');
	}

	public function locations()
	{
		return $this->hasMany('Location');
	}

	public function analyticsclients()
	{
		return $this->hasMany('Analyticsclient');
	}

	public function adsclients()
	{
		return $this->hasMany('Adsclient', 'user_id', 'id');
	}

}