<?php

namespace App\Models;

class Zipcode extends Eloquent {

	protected $table = 'zipcodes';
	public $timestamps = true;
	protected $fillable = array('zip', 'location_id', 'clinic_id');
	protected $visible = array('zip', 'location_id', 'clinic_id');

	public function location()
	{
		return $this->belongsTo('Location');
	}

	public function clinic()
	{
		return $this->belongsTo('Clinic');
	}

	public function profile()
	{
		return $this->belongsToMany('Profile');
	}

}