<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('email');
			$table->integer('country_id')->unsigned();
			$table->integer('city_id');
			$table->string('telephone')->nullable();
			$table->text('about')->nullable();
			$table->tinyInteger('type');
			$table->string('website')->nullable();
			$table->string('license_of_hajj')->nullable();
			$table->string('commercial_register')->nullable();
			$table->string('iata_number')->nullable();
			$table->string('logo')->nullable();
			$table->bigInteger('counterpart_id')->unsigned();
			$table->string('license');
			$table->boolean('active')->default(0);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}