<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('name');
			$table->string('email')->unique();
			$table->string('password');
			$table->tinyInteger('user_type');
			$table->string('logo')->nullable();
			$table->boolean('suspended')->default(0);
			$table->boolean('active')->default(0);
			$table->boolean('is_super_admin')->default(0);
			$table->rememberToken('rememberToken');
			$table->morphs('userable');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}