<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCounterpartsTable extends Migration {

	public function up()
	{
		Schema::create('counterparts', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('email');
			$table->integer('country_id')->unsigned();
			$table->string('name');
			$table->string('address')->nullable();
			$table->string('telephone')->nullable();
			$table->string('fax')->nullable();
			$table->string('mobile')->nullable();
			$table->string('logo')->nullable();
			$table->boolean('active')->default(0);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('counterparts');
	}
}