<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('counterpart_id')->references('id')->on('counterparts')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('companies_trans', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('countries_trans', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('currencies_trans', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('currencies')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('counterparts', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('companies_licenses_counterparts', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('companies_services', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('companies_services', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->foreign('category_service_id')->references('id')->on('categories_services')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('services_trans', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('categories_services_trans', function(Blueprint $table) {
			$table->foreign('category_service_id')->references('id')->on('categories_services')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('dispute_id')->references('id')->on('disputes')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('comments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('send_to')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('disputes_sessions', function(Blueprint $table) {
			$table->foreign('dispute_id')->references('id')->on('disputes')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('disputes_representatives', function(Blueprint $table) {
			$table->foreign('dispute_session_id')->references('id')->on('disputes_sessions')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('disputes_decisions', function(Blueprint $table) {
			$table->foreign('dispute_id')->references('id')->on('disputes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('disputes_reports', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_country_id_foreign');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_counterpart_id_foreign');
		});
		Schema::table('companies_trans', function(Blueprint $table) {
			$table->dropForeign('companies_trans_company_id_foreign');
		});
		Schema::table('countries_trans', function(Blueprint $table) {
			$table->dropForeign('countries_trans_country_id_foreign');
		});
		Schema::table('currencies_trans', function(Blueprint $table) {
			$table->dropForeign('currencies_trans_currency_id_foreign');
		});
		Schema::table('counterparts', function(Blueprint $table) {
			$table->dropForeign('counterparts_country_id_foreign');
		});
		Schema::table('companies_licenses_counterparts', function(Blueprint $table) {
			$table->dropForeign('companies_licenses_counterparts_company_id_foreign');
		});
		Schema::table('companies_services', function(Blueprint $table) {
			$table->dropForeign('companies_services_company_id_foreign');
		});
		Schema::table('companies_services', function(Blueprint $table) {
			$table->dropForeign('companies_services_service_id_foreign');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->dropForeign('services_category_service_id_foreign');
		});
		Schema::table('services_trans', function(Blueprint $table) {
			$table->dropForeign('services_trans_service_id_foreign');
		});
		Schema::table('categories_services_trans', function(Blueprint $table) {
			$table->dropForeign('categories_services_trans_category_service_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_dispute_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_parent_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_user_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_send_to_foreign');
		});
		Schema::table('disputes_sessions', function(Blueprint $table) {
			$table->dropForeign('disputes_sessions_dispute_id_foreign');
		});
		Schema::table('disputes_representatives', function(Blueprint $table) {
			$table->dropForeign('disputes_representatives_dispute_session_id_foreign');
		});
		Schema::table('disputes_decisions', function(Blueprint $table) {
			$table->dropForeign('disputes_decisions_dispute_id_foreign');
		});
		Schema::table('disputes_reports', function(Blueprint $table) {
			$table->dropForeign('disputes_reports_created_by_foreign');
		});
	}
}