<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Service extends Eloquent {

	protected $table = 'services';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function trans()
	{
		return $this->hasMany('App\Models\ServiceTrans');
	}

	public function category()
	{
		return $this->belongsTo('App\Models\CategoryService');
	}

}