<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function counterpart()
	{
		return $this->morphOne('App\Models\Counterpart');
	}

	public function company()
	{
		return $this->morphOne('App\Models\Company');
	}

}