<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function counterpart()
    {
        return $this->morphOne('App\Models\Counterpart');
    }

    public function company()
    {
        return $this->morphOne('App\Models\Company');
    }

}