<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemsTable extends Migration {

	public function up()
	{
		Schema::create('items', function(Blueprint $table) {
			$table->bigIncrements('id', true);
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('return_id')->unsigned()->index();
			$table->bigInteger('cart_id')->unsigned()->index();
			$table->double('amount')->default('0');
			$table->integer('quantity')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('items');
	}
}