<?php

namespace App;

class Article extends Eloquent {

	protected $table = 'articles';
	public $timestamps = true;
	protected $fillable = array('timestamps', 'title', 'subtitle', 'content', 'user_id', 'slug', 'category_id', 'validated');

	public function author()
	{
		return $this->belongsTo('App\User');
	}

	public function images()
	{
		return $this->hasMany('App\Image');
	}

	public function category()
	{
		return $this->belongsTo('App\Category');
	}

}