<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStagesTable extends Migration {

	public function up()
	{
		Schema::create('stages', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->string('excerpt')->nullable();
			$table->text('description')->nullable();
			$table->string('icon')->nullable();
			$table->string('type')->nullable();
			$table->string('button_name')->nullable();
			$table->boolean('is_button')->default(0);
			$table->boolean('is_enabled')->default(0);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('stages');
	}
}