<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProgramsTable extends Migration {

	public function up()
	{
		Schema::create('programs', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->string('excerpt')->nullable();
			$table->text('description');
			$table->string('redirect_url')->nullable();
			$table->string('button_name')->nullable();
			$table->boolean('is_button')->default(1);
			$table->boolean('is_enabled');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('programs');
	}
}