<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Lead extends Model 
{

    protected $table = 'leads';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'phone', 'mail', 'vacancy_id');
    protected $visible = array('name', 'phone', 'mail', 'vacancy_id');

    public function getVacancy()
    {
        return $this->hasOne('Vacancy');
    }

    public function getCity()
    {
        return $this->hasOne('City');
    }

    public function getFiles()
    {
        return $this->belongsToMany('File', 'user_id');
    }

}