<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('username', 8);
			$table->string('first_name', 50);
			$table->string('last_name', 50);
			$table->string('email', 60)->unique();
			$table->string('password');
			$table->smallInteger('puntos')->unsigned()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}