<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWarehousesTable extends Migration {

	public function up()
	{
		Schema::create('warehouses', function(Blueprint $table) {
			$table->timestamps();
			$table->increments('id');
			$table->string('name');
			$table->string('phone')->unique();
			$table->string('email')->unique();
			$table->string('password');
			$table->string('address')->nullable();
			$table->decimal('latitude')->nullable();
			$table->decimal('longitude')->nullable();
			$table->string('warehouse_data')->nullable();
			$table->tinyInteger('status')->default('1');
			$table->bigInteger('city_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('warehouses');
	}
}